(************************************************************************
 *                                                                      *
 *   Ant Movie Catalog 4.x                                              *
 *   (C) 2000-2011 Antoine Potten, Mickal Vanneufville                 *
 *   http://www.antp.be/software                                        *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)

unit ConstValues;

interface

uses
  Classes, Dialogs, Graphics, SysUtils, Fields;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

const
  strDate = '2011-10-22';
  strErrorParenthesis = '< ?()? >';

const
  ddlMediaType  = 0;
  ddlSources    = 1;
  ddlBorrowers  = 2;
  ddlCountry    = 3;
  ddlCategory   = 4;
  ddlVideo      = 5;
  ddlAudio      = 6;
  ddlFramerate  = 7;
  ddlLanguages  = 8;
  ddlSubtitles  = 9;

const
  strFieldsDdl: array [0..9] of Integer =
    ( fieldMediaType, fieldSource, fieldBorrower, fieldCountry,
      fieldCategory, fieldVideoFormat, fieldAudioFormat, fieldFrameRate,
      fieldLanguages, fieldSubtitles );
  strXMLDdl: array [0..9] of string =
    ( 'Media', 'Sources', 'Borrowers', 'Country', 'Category',
      'Video', 'Audio', 'Framerate', 'Languages', 'Subtitles' );
  DefaultColors: array [0..11] of TColor =
    ( $FFFFFF, $241ced, $277fff, $00f2ff, $1de6b5, $4cb122, $eeee1c, $ffa030, $ff8080, $e00ed0, $d080ff, $999999 );

const
  strFileCodecs       = 'Codecs.ini';
  strFileHelp         = 'English.chm';
  strFilePrefixes     = 'Prefixes.txt';
  strFileExchangeDLL  = 'AMCExchange.dll';
  strFileDesigner     = 'AMCReport.exe';
  strFileDefault      = 'default.xml';
  strFileScriptsCache = 'scripts.ini';
  strFileMediaInfoDLL = 'MediaInfo.dll';
  strFileNoPoster     = 'noposter.jpg';
  strFileNoFileFound  = 'nofilefound.jpg';
var
  strFileSettings: TFileName = 'prefs.xml';

const
  strDirToolbars      = 'Toolbars\';
  strDirLanguages     = 'Languages\';
  strDirTemplates     = 'Templates\';
  strDirLists         = 'Lists\';
  strDirScripts       = 'Scripts\';
  strDirCatalogs      = 'Catalogs\';

  // Dialogs
  DialogImageFilter       = 'PNG, JPEG, GIF (*.png, *.jpg, *.jpe, *.jpeg, *.gif)|*.png;*.jpg;*.jpe;*.jpeg;*.gif';
  DialogScriptFilter      = 'Innerfuse Pascal Scripts (*.ifs, *.pas)|*.ifs;*.pas|Text Files|*.txt|All Files (*.*)|*.*';
  DialogGetInfoFilter     = 'All Supported Files|%0:s;*.film;*.png;*.gif;*.jpg|Video Files|%0:s|Image files|*.png;*.gif;*.jpg;*.jpe;*.jpeg|MovieCovers'' .film Files|*.film|All Files|*.*';
  DialogCatalogFilter     = 'Ant Movie Catalog Files (*.amc, *.xml)|*.amc;*.xml';
  DialogCatalogSaveFilter = 'Ant Movie Catalog 4.0 (*.amc)|*.amc|Ant Movie Catalog 3.5 (*.amc)|*.amc|XML (*.xml)|*.xml';
  DialogCSVFilter         = 'CSV & tab-delimited text|*.csv;*.txt';
  DialogHTMLFilter        = 'HTML Files (*.html, *.htm)|*.html;*.htm';
  DialogSQLFilter         = 'SQL Commands (*.sql, *.txt)|*.sql;*.txt';
  DialogReportFilter      = 'FreeReport Files (*.frf)|*.frf';
  DialogChartFilter       = 'Metafile (*.wmf)|*.wmf|PNG (*.png)|*.png|Bitmap (*.bmp)|*.bmp';
  DialogAnyFileFilter     = 'All Files (*.*)|*.*';
  DialogXmlFilter         = 'XML (*.xml)|*.xml';
  DialogBDVFilter         = 'BaseDVDivx Files (*.bdv)|*.bdv';
  DialogMLBFilter         = 'MyLittleBase (*.mlb, *.bdv)|*.mlb;*.bdv';
  DialogDivxMgrFilter     = 'eXtreme Movie Manager / Divx Manager (*.mdb)|*.mdb';
  DialogOrigonsFilter     = 'Origons Import/Export (*.ogs)|*.ogs|All Files (*.*)|*.*';
  DialogMDBFilter         = 'Microsoft Access Database (*.mdb)|*.mdb';

  DialogCatalogFilterAMC  = 1;
  DialogCatalogFilterAMC35 = 2;
  DialogCatalogFilterXML  = 3;

  DialogChartFilterWMF    = 1;
  DialogChartFilterPNG    = 2;
  DialogChartFilterBMP    = 3;

  DialogOpenOptions = [ofHideReadOnly,ofPathMustExist,ofFileMustExist,ofEnableSizing];
  DialogSaveOptions = [ofOverwritePrompt,ofHideReadOnly,ofPathMustExist,ofNoReadOnlyReturn,ofEnableSizing];

  // Toolbar Icons
type
  TIconIndex = (
  ICON_FILENEW,
  ICON_FILEOPEN,
  ICON_FILESAVE,
  ICON_FILESAVEAS,
  ICON_FILEIMPORT,
  ICON_FILEEXPORT,
  ICON_FILEPRINT,
  ICON_FILEPROPERTIES,
  ICON_MOVIEADD,
  ICON_MOVIENUMBER,
  ICON_MOVIEDELETE,
  ICON_MOVIEFIND,
  ICON_MOVIECOPY,
  ICON_MOVIEPASTE,
  ICON_MOVIEUNDO,
  ICON_MOVIEPICTURE,
  ICON_PICTUREOPEN,
  ICON_PICTURESAVE,
  ICON_PICTURECOPY,
  ICON_PICTUREDELETE,
  ICON_PICTUREUNDOCK,
  ICON_MOVIEIMPORT,
  ICON_MOVIEIMPORTFILES,
  ICON_MOVIEIMPORTSCRIPT,
  ICON_MOVIEIMPORTCD,
  ICON_MOVIESEARCH,
  ICON_SCRIPTING,
  ICON_GRIDMODE,
  ICON_RENUMBER,
  ICON_STATISTICS,
  ICON_LOANS,
  ICON_OPTIONS,
  ICON_LANGUAGES,
  ICON_GROUP,
  ICON_REFRESH,
  ICON_HELP,
  ICON_ABOUT,
  ICON_EXIT,
  ICON_LOANBORROWADD,
  ICON_LOANBORROWDEL,
  ICON_LOANBORROWGET,
  ICON_LOANCHECKIN,
  ICON_LOANCHECKOUT,
  ICON_LOANOPTIONS,
  ICON_LOANFIND,
  ICON_TEMPLATENEW,
  ICON_TEMPLATELOAD,
  ICON_TEMPLATESAVE,
  ICON_TEMPLATESAVEAS,
  ICON_STATSSAVE,
  ICON_STATSCOPY,
  ICON_STATSOPTIONS,
  ICON_SCRIPTNEW,
  ICON_SCRIPTOPEN,
  ICON_SCRIPTSAVE,
  ICON_SCRIPTSAVEAS,
  ICON_SCRIPTSPROPERTIES,
  ICON_SCRIPTFIND,
  ICON_SCRIPTFINDNEXT,
  ICON_DEBUGRUN,
  ICON_DEBUGSTOP,
  ICON_DEBUGBREAKPOINT,
  ICON_DEBUGBREAKCLEAR,
  ICON_DEBUGSTEPOVER,
  ICON_DEBUGRUNTOCURSOR,
  ICON_DEBUGEVALUATE,
  ICON_DEBUGWATCHADD,
  ICON_DEBUGWATCHREMOVE,
  ICON_DEBUGWATCHCLEAR,
  ICON_VIEWFILTER,
  ICON_VIEWLIST,
  ICON_VIEWDETAIL,
  ICON_PRINTREFRESH,
  ICON_PRINTPAGEFIRST,
  ICON_PRINTPAGEPREVIOUS,
  ICON_PRINTPAGENEXT,
  ICON_PRINTPAGELAST,
  ICON_PRINTPAGEFULL,
  ICON_PRINTPAGETWO,
  ICON_PRINTPAGEWIDTH,
  ICON_PRINTLOAD,
  ICON_PRINTZOOMOUT,
  ICON_PRINTZOOMIN,
  ICON_PRINT,
  ICON_PRINTDESIGNER,
  ICON_BROWSE,
  ICON_ROWINSERT,
  ICON_ROWDELETE,
  ICON_MOVEUP,
  ICON_MOVEDOWN,
  ICON_MOVELEFT,
  ICON_MOVERIGHT,
  ICON_MOVELEFTALL,
  ICON_MOVERIGHTALL,
  ICON_RANDOM,
  ICON_HTML,
  ICON_FIELDEDIT,
  ICON_FIELDADD,
  ICON_FIELDDEL,
  ICON_FIELDMOVE,
  ICON_FIELD
  );

const
  ftDefault = 0;
  ftLast    = 1;
  ftUser    = 2;

  fuCatalogs      = 0;
  fuPicture       = 1;
  fuExport        = 2;
  fuTemplates     = 3;
  fuImport        = 4;
  fuGetFromFiles  = 5;
  fuGraphic       = 6;
  fuScripts       = 7;
  fuCustomFields  = 8;

const
  extImage: array [0..4] of string =
    ('.png', '.gif', '.jpg', '.jpe', '.jpeg');
  typeImage: array [0..4] of string =
    ('PNG', 'GIF', 'JPEG', 'JPEG', 'JPEG');
  extVideo: array [0..22] of string =
    ('.avi',  '.divx', '.mpg',  '.mpeg', '.mpe',
     '.dat',  '.wmv',  '.asf',  '.mov',  '.rm',
     '.mp4',  '.ogg', '.xvid',  '.mkv',  '.rmvb',
     '.rv9',  '.ogm', '.ifo',   '.vob',  '.ts',
     '.flv',  '.m2ts','.evo');
  extScript: array[0..1] of string =
    ('.ifs', '.pas');
  extCatalog: array[0..1] of string =
    ('.amc', '.xml');
  extChart: array[0..2] of string =
    ('.wmf', '.png', '.bmp');

const
  extAMC = 0;
  extXML = 1;
  extPNG = 0;
  extGIF = 1;
  extJPG = 2;
  extJPE = 3;
  extJPEG = 4;
  extChWMF = 0;
  extChPNG = 1;
  extchBMP = 2;
  extIFS = 0;
  extPAS = 1;
  extAVI = 0;
  extDIVX = 1;
  extTS = 19;

const
  TAG_FILENAME             ='$$FILENAME';
  TAG_FILEPATH             ='$$FILEPATH';
  TAG_TOTALMOVIES          ='$$TOTALMOVIES';
  TAG_TOTALDISKS           ='$$TOTALDISKS';

  TAG_DATE                 ='$$DATE';
  TAG_TIME                 ='$$TIME';

  TAG_OWNERNAME            ='$$OWNER_NAME';
  TAG_OWNERMAIL            ='$$OWNER_MAIL';
  TAG_OWNERSITE            ='$$OWNER_SITE';
  TAG_DESCRIPTION          ='$$DESCRIPTION';

  TAG_ITEMBEGIN            ='$$ITEM_BEGIN';
  TAG_ITEMEND              ='$$ITEM_END';
  TAG_RECNR                ='$$ITEM_RECNR';
  TAG_ITEMFILEINDIV        ='$$ITEM_FILEINDIV';
  TAG_ITEMNUMBER           ='$$ITEM_NUMBER';
  TAG_ITEMCHECKED          ='$$ITEM_CHECKED';
  TAG_ITEMMEDIA            ='$$ITEM_MEDIA';
  TAG_ITEMTYPE             ='$$ITEM_TYPE';
  TAG_ITEMSOURCE           ='$$ITEM_SOURCE';
  TAG_ITEMDATEADD          ='$$ITEM_DATEADD';
  TAG_ITEMBORROWER         ='$$ITEM_BORROWER';
  TAG_ITEMAPPRECIATION     ='$$ITEM_APPRECIATION';
  TAG_ITEMAPPR10           ='$$ITEM_APPR10';
  TAG_ITEMRATING           ='$$ITEM_RATING';
  TAG_ITEMORIGINALTITLE    ='$$ITEM_ORIGINALTITLE';
  TAG_ITEMTRANSLATEDTITLE  ='$$ITEM_TRANSLATEDTITLE';
  TAG_ITEMFORMATTEDTITLE1  ='$$ITEM_FORMATTEDTITLE1';
  TAG_ITEMFORMATTEDTITLE2  ='$$ITEM_FORMATTEDTITLE2';
  TAG_ITEMFORMATTEDTITLE   ='$$ITEM_FORMATTEDTITLE';
  TAG_ITEMDIRECTOR         ='$$ITEM_DIRECTOR';
  TAG_ITEMPRODUCER         ='$$ITEM_PRODUCER';
  TAG_ITEMCOUNTRY          ='$$ITEM_COUNTRY';
  TAG_ITEMCATEGORY         ='$$ITEM_CATEGORY';
  TAG_ITEMYEAR             ='$$ITEM_YEAR';
  TAG_ITEMLENGTH           ='$$ITEM_LENGTH';
  TAG_ITEMACTORS           ='$$ITEM_ACTORS';
  TAG_ITEMURL              ='$$ITEM_URL';
  TAG_ITEMDESCRIPTION      ='$$ITEM_DESCRIPTION';
  TAG_ITEMCOMMENTS         ='$$ITEM_COMMENTS';
  TAG_ITEMFORMAT           ='$$ITEM_FORMAT';
  TAG_ITEMVIDEOFORMAT      ='$$ITEM_VIDEOFORMAT';
  TAG_ITEMVIDEOBITRATE     ='$$ITEM_VIDEOBITRATE';
  TAG_ITEMAUDIOFORMAT      ='$$ITEM_AUDIOFORMAT';
  TAG_ITEMAUDIOBITRATE     ='$$ITEM_AUDIOBITRATE';
  TAG_ITEMRESOLUTION       ='$$ITEM_RESOLUTION';
  TAG_ITEMFRAMERATE        ='$$ITEM_FRAMERATE';
  TAG_ITEMLANGUAGES        ='$$ITEM_LANGUAGES';
  TAG_ITEMSUBTITLES        ='$$ITEM_SUBTITLES';
  TAG_ITEMSIZE             ='$$ITEM_SIZE';
  TAG_ITEMDISKS            ='$$ITEM_DISKS';
  TAG_ITEMPICTURE          ='$$ITEM_PICTURE';
  TAG_ITEMPICTUREFILENAME  ='$$ITEM_PICTUREFILENAME';

  TAG_LABELNUMBER          ='$$LABEL_NUMBER';
  TAG_LABELCHECKED         ='$$LABEL_CHECKED';
  TAG_LABELMEDIA           ='$$LABEL_MEDIA';
  TAG_LABELTYPE            ='$$LABEL_TYPE';
  TAG_LABELSOURCE          ='$$LABEL_SOURCE';
  TAG_LABELDATEADD         ='$$LABEL_DATEADD';
  TAG_LABELBORROWER        ='$$LABEL_BORROWER';
  TAG_LABELRATING          ='$$LABEL_RATING';
  TAG_LABELORIGINALTITLE   ='$$LABEL_ORIGINALTITLE';
  TAG_LABELTRANSLATEDTITLE ='$$LABEL_TRANSLATEDTITLE';
  TAG_LABELFORMATTEDTITLE  ='$$LABEL_FORMATTEDTITLE';
  TAG_LABELDIRECTOR        ='$$LABEL_DIRECTOR';
  TAG_LABELPRODUCER        ='$$LABEL_PRODUCER';
  TAG_LABELCOUNTRY         ='$$LABEL_COUNTRY';
  TAG_LABELCATEGORY        ='$$LABEL_CATEGORY';
  TAG_LABELYEAR            ='$$LABEL_YEAR';
  TAG_LABELLENGTH          ='$$LABEL_LENGTH';
  TAG_LABELACTORS          ='$$LABEL_ACTORS';
  TAG_LABELURL             ='$$LABEL_URL';
  TAG_LABELDESCRIPTION     ='$$LABEL_DESCRIPTION';
  TAG_LABELCOMMENTS        ='$$LABEL_COMMENTS';
  TAG_LABELVIDEOFORMAT     ='$$LABEL_VIDEOFORMAT';
  TAG_LABELVIDEOBITRATE    ='$$LABEL_VIDEOBITRATE';
  TAG_LABELAUDIOFORMAT     ='$$LABEL_AUDIOFORMAT';
  TAG_LABELAUDIOBITRATE    ='$$LABEL_AUDIOBITRATE';
  TAG_LABELRESOLUTION      ='$$LABEL_RESOLUTION';
  TAG_LABELFRAMERATE       ='$$LABEL_FRAMERATE';
  TAG_LABELLANGUAGES       ='$$LABEL_LANGUAGES';
  TAG_LABELSUBTITLES       ='$$LABEL_SUBTITLES';
  TAG_LABELSIZE            ='$$LABEL_SIZE';
  TAG_LABELDISKS           ='$$LABEL_DISKS';
  TAG_LABELPICTURE         ='$$LABEL_PICTURE';
  TAG_LABELAUDIOKBPS       ='$$LABEL_AUDIOKBPS';
  TAG_LABELVIDEOKBPS       ='$$LABEL_VIDEOKBPS';
  TAG_LABELUNIT            ='$$LABEL_UNIT';
  TAG_LABELFPS             ='$$LABEL_FPS';

  // Do not add to strListTags !
  // This is just the start model for custom fields tag.
  TAG_ITEM_CF              ='$$ITEM_CF_';
  TAG_LABEL_CF             ='$$LABEL_CF_';

var
  strDirApp: string;
  strAppExe: string;
  strVersion: string;
  strFullVersion: string;
  strListTags: TStringList;


{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

implementation

uses
  functions_files, functions_str;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

initialization
  strAppExe := ParamStr(0);
  strDirApp := ExtractFilePath(strAppExe);
  strFullVersion := GetBuild4(strAppExe);
  strVersion := Copy(strFullVersion, 1, LastPos('.', strFullVersion) - 1);
  strListTags := TStringList.Create;
  strListTags.CaseSensitive := False;
  strListTags.Add(TAG_FILENAME);
  strListTags.Add(TAG_FILEPATH);
  strListTags.Add(TAG_TOTALMOVIES);        
  strListTags.Add(TAG_TOTALDISKS);         
  strListTags.Add(TAG_DATE);               
  strListTags.Add(TAG_TIME);               
  strListTags.Add(TAG_OWNERNAME);          
  strListTags.Add(TAG_OWNERMAIL);          
  strListTags.Add(TAG_OWNERSITE);          
  strListTags.Add(TAG_DESCRIPTION);        
  strListTags.Add(TAG_ITEMBEGIN);          
  strListTags.Add(TAG_ITEMEND);            
  strListTags.Add(TAG_RECNR);              
  strListTags.Add(TAG_ITEMFILEINDIV);      
  strListTags.Add(TAG_ITEMNUMBER);         
  strListTags.Add(TAG_ITEMCHECKED);        
  strListTags.Add(TAG_ITEMMEDIA);          
  strListTags.Add(TAG_ITEMTYPE);           
  strListTags.Add(TAG_ITEMSOURCE);         
  strListTags.Add(TAG_ITEMDATEADD);        
  strListTags.Add(TAG_ITEMBORROWER);       
  strListTags.Add(TAG_ITEMAPPRECIATION);
  strListTags.Add(TAG_ITEMAPPR10);
  strListTags.Add(TAG_ITEMRATING);         
  strListTags.Add(TAG_ITEMORIGINALTITLE);  
  strListTags.Add(TAG_ITEMTRANSLATEDTITLE);
  strListTags.Add(TAG_ITEMFORMATTEDTITLE1);
  strListTags.Add(TAG_ITEMFORMATTEDTITLE2);
  strListTags.Add(TAG_ITEMFORMATTEDTITLE); 
  strListTags.Add(TAG_ITEMDIRECTOR);       
  strListTags.Add(TAG_ITEMPRODUCER);
  strListTags.Add(TAG_ITEMCOUNTRY);
  strListTags.Add(TAG_ITEMCATEGORY);       
  strListTags.Add(TAG_ITEMYEAR);           
  strListTags.Add(TAG_ITEMLENGTH);         
  strListTags.Add(TAG_ITEMACTORS);         
  strListTags.Add(TAG_ITEMURL);            
  strListTags.Add(TAG_ITEMDESCRIPTION);    
  strListTags.Add(TAG_ITEMCOMMENTS);       
  strListTags.Add(TAG_ITEMFORMAT);         
  strListTags.Add(TAG_ITEMVIDEOFORMAT);    
  strListTags.Add(TAG_ITEMVIDEOBITRATE);   
  strListTags.Add(TAG_ITEMAUDIOFORMAT);    
  strListTags.Add(TAG_ITEMAUDIOBITRATE);   
  strListTags.Add(TAG_ITEMRESOLUTION);     
  strListTags.Add(TAG_ITEMFRAMERATE);      
  strListTags.Add(TAG_ITEMLANGUAGES);      
  strListTags.Add(TAG_ITEMSUBTITLES);      
  strListTags.Add(TAG_ITEMSIZE);           
  strListTags.Add(TAG_ITEMDISKS);
  strListTags.Add(TAG_ITEMPICTUREFILENAME); // Warning put before TAG_ITEMPICTURE !
  strListTags.Add(TAG_ITEMPICTURE);
  strListTags.Add(TAG_LABELNUMBER);          
  strListTags.Add(TAG_LABELCHECKED);         
  strListTags.Add(TAG_LABELMEDIA);           
  strListTags.Add(TAG_LABELTYPE);            
  strListTags.Add(TAG_LABELSOURCE);          
  strListTags.Add(TAG_LABELDATEADD);         
  strListTags.Add(TAG_LABELBORROWER);        
  strListTags.Add(TAG_LABELRATING);          
  strListTags.Add(TAG_LABELORIGINALTITLE);
  strListTags.Add(TAG_LABELTRANSLATEDTITLE);
  strListTags.Add(TAG_LABELFORMATTEDTITLE);
  strListTags.Add(TAG_LABELDIRECTOR);        
  strListTags.Add(TAG_LABELPRODUCER);        
  strListTags.Add(TAG_LABELCOUNTRY);         
  strListTags.Add(TAG_LABELCATEGORY);        
  strListTags.Add(TAG_LABELYEAR);            
  strListTags.Add(TAG_LABELLENGTH);          
  strListTags.Add(TAG_LABELACTORS);          
  strListTags.Add(TAG_LABELURL);             
  strListTags.Add(TAG_LABELDESCRIPTION);     
  strListTags.Add(TAG_LABELCOMMENTS);        
  strListTags.Add(TAG_LABELVIDEOFORMAT);     
  strListTags.Add(TAG_LABELVIDEOBITRATE);    
  strListTags.Add(TAG_LABELAUDIOFORMAT);     
  strListTags.Add(TAG_LABELAUDIOBITRATE);    
  strListTags.Add(TAG_LABELRESOLUTION);      
  strListTags.Add(TAG_LABELFRAMERATE);       
  strListTags.Add(TAG_LABELLANGUAGES);       
  strListTags.Add(TAG_LABELSUBTITLES);       
  strListTags.Add(TAG_LABELSIZE);            
  strListTags.Add(TAG_LABELDISKS);           
  strListTags.Add(TAG_LABELPICTURE);         
  strListTags.Add(TAG_LABELAUDIOKBPS);       
  strListTags.Add(TAG_LABELVIDEOKBPS);       
  strListTags.Add(TAG_LABELUNIT);            
  strListTags.Add(TAG_LABELFPS);

finalization
  strListTags.Free;
end.
